program Listing6;

uses
  RTTI, System.SysUtils, TypInfo, System.Classes, System.StrUtils;

type
  TRozszerzonyInterfejsWirtualny<T: IInvokable> = class(TVirtualInterface)
  protected
    procedure WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
    procedure WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue); virtual; abstract;
  public
    constructor Create;
  end;

constructor TRozszerzonyInterfejsWirtualny<T>.Create;
begin
  inherited Create(TypeInfo(T), WywołajMetodę);
end;

procedure TRozszerzonyInterfejsWirtualny<T>.WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
  WywołajMetodęImpl(Metoda, Argumenty, Wynik);
end;

type
  IProstaAtrapa<T> = interface
    ['{6AA7C2F0-E62F-497B-9A77-04D6F369A288}']
    function WywoływanyInterfejs: T;
  end;

  TProstaAtrapa<T: IInvokable> = class(TRozszerzonyInterfejsWirtualny<T>, IProstaAtrapa<T>)
  protected
    procedure WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue); override;
  public
    function WywoływanyInterfejs: T;
  end;

procedure TProstaAtrapa<T>.WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
// Ponieważ jest to atrapa, nie można nic robić!
end;

function TProstaAtrapa<T>.WywoływanyInterfejs: T;
var
  pInfo : PTypeInfo;
begin
  pInfo := TypeInfo(T);
  if QueryInterface(GetTypeData(pInfo).Guid, Result) <> 0 then
  begin
    raise Exception.CreateFmt('Niestety, TProstaAtrapa<T> nie może zmienić typu %s na interfejs', [string(pInfo.Name)]);
  end;
end;

type
  IPrzydatnyInterfejs = interface(IInvokable)
    ['{16F01BF0-961F-4461-AEBE-B1ACB8D3F0F4}']
    procedure Witaj;
    function TekstWstecz(aTekst: string): string;
    function Iloczyn(x, y: integer): integer;
  end;

var
  ProstaAtrapa: IProstaAtrapa<IPrzydatnyInterfejs>;
begin
  WriteLn('Implementacja klasy TProstaAtrapa');
  ProstaAtrapa := TProstaAtrapa<IPrzydatnyInterfejs>.Create;
  WriteLn('Między tym a poniższym wierszem nie powinno się nic pojawić');
  ProstaAtrapa.WywoływanyInterfejs.Witaj;
  ProstaAtrapa.WywoływanyInterfejs.Iloczyn(4, 4);
  ProstaAtrapa.WywoływanyInterfejs.TekstWstecz('Przykładowy tekst');
  WriteLn('Między tym a powyższym wierszem nie powinno się nic pojawić');
  ReadLn;
end.

